/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.string.Strings;

public class AbstractUpgradeFilter
extends WicketFilter {
    public AbstractUpgradeFilter() {
    }

    public AbstractUpgradeFilter(WebApplication application) {
        super(application);
    }

    protected boolean processRequestCycle(RequestCycle requestCycle, WebResponse webResponse, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain chain) throws IOException, ServletException {
        ThreadContext.setRequestCycle((RequestCycle)requestCycle);
        if (this.acceptWebSocket(httpServletRequest, httpServletResponse) || httpServletResponse.isCommitted()) {
            return true;
        }
        return super.processRequestCycle(requestCycle, webResponse, httpServletRequest, httpServletResponse, chain);
    }

    protected boolean acceptWebSocket(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String subProtocol = null;
        if (!this.headerContainsToken(req, "Upgrade", "websocket")) {
            return false;
        }
        if (!this.headerContainsToken(req, "Connection", "upgrade")) {
            resp.sendError(400);
            return false;
        }
        if (!this.headerContainsToken(req, "Sec-websocket-version", "13")) {
            resp.setStatus(400);
            resp.setHeader("Sec-WebSocket-Version", "13");
            return false;
        }
        String key = req.getHeader("Sec-WebSocket-Key");
        if (key == null) {
            resp.sendError(400);
            return false;
        }
        String origin = req.getHeader("Origin");
        if (!this.verifyOrigin(origin)) {
            resp.sendError(403);
            return false;
        }
        List<String> subProtocols = this.getTokensFromHeader(req, "Sec-WebSocket-Protocol-Client");
        if (!subProtocols.isEmpty()) {
            subProtocol = this.selectSubProtocol(subProtocols);
        }
        if (subProtocol != null) {
            resp.setHeader("Sec-WebSocket-Protocol", subProtocol);
        }
        return true;
    }

    private boolean headerContainsToken(HttpServletRequest req, String headerName, String target) {
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = Strings.split((String)header, (char)',')) {
                if (!target.equalsIgnoreCase(token.trim())) continue;
                return true;
            }
        }
        return false;
    }

    protected List<String> getTokensFromHeader(HttpServletRequest req, String headerName) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration headers = req.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            for (String token : tokens = Strings.split((String)header, (char)',')) {
                result.add(token.trim());
            }
        }
        return result;
    }

    protected boolean verifyOrigin(String origin) {
        return true;
    }

    protected String selectSubProtocol(List<String> subProtocols) {
        return null;
    }
}

