/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.sling.commons.osgi.ManifestHeader;
import org.apache.sling.i18n.impl.JcrResourceBundleProvider;
import org.apache.sling.i18n.impl.LocatorPaths;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocatorPathsTracker
implements BundleTrackerCustomizer<Set<LocatorPaths>> {
    private static final String CAPABILITY_I18N_RESOURCEBUNDLE_LOCATOR = "org.apache.sling.i18n.resourcebundle.locator";
    private static final String ATTR_PATHS = "paths";
    private static final String ATTR_DEPTH = "depth";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private JcrResourceBundleProvider rbp;

    public LocatorPathsTracker(JcrResourceBundleProvider provider) {
        this.rbp = provider;
    }

    public Set<LocatorPaths> addingBundle(Bundle bundle, BundleEvent event) {
        this.log.debug("Considering bundle for registering resource bundle locator paths: {}", (Object)bundle.getSymbolicName());
        HashSet<LocatorPaths> pathsSet = null;
        String provideCapability = (String)bundle.getHeaders().get("Provide-Capability");
        if (provideCapability != null) {
            ManifestHeader header = ManifestHeader.parse(provideCapability);
            for (ManifestHeader.Entry entry : header.getEntries()) {
                String[] items;
                String paths;
                if (!CAPABILITY_I18N_RESOURCEBUNDLE_LOCATOR.equals(entry.getValue()) || (paths = entry.getAttributeValue(ATTR_PATHS)) == null) continue;
                if (pathsSet == null) {
                    pathsSet = new HashSet<LocatorPaths>();
                }
                int traversalDepth = 1;
                String depth = entry.getAttributeValue(ATTR_DEPTH);
                if (depth != null && !depth.isEmpty()) {
                    traversalDepth = Integer.parseInt(depth);
                }
                for (String path : items = paths.split(",")) {
                    if ((path = path.trim()).isEmpty()) continue;
                    pathsSet.add(new LocatorPaths(path, traversalDepth, bundle.getBundleId()));
                }
            }
            if (pathsSet != null) {
                this.log.info("Registered {} resource bundle locator paths for bundle: {}", (Object)pathsSet.size(), (Object)bundle.getSymbolicName());
                this.rbp.registerLocatorPaths((Set<LocatorPaths>)pathsSet);
            }
        }
        return pathsSet;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Set<LocatorPaths> baseNamesSet) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Set<LocatorPaths> baseNamesSet) {
        this.log.info("Unregistered {} resource bundle locator paths for bundle: {}", (Object)baseNamesSet.size(), (Object)bundle.getSymbolicName());
        this.rbp.unregisterLocatorPaths(baseNamesSet);
    }
}

