/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.executor.facade;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.kernel.executor.facade.JobFacade;
import org.apache.shardingsphere.elasticjob.kernel.executor.facade.JobJobRuntimeServiceImpl;
import org.apache.shardingsphere.elasticjob.kernel.infra.exception.JobExecutionEnvironmentException;
import org.apache.shardingsphere.elasticjob.kernel.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.kernel.internal.context.TaskContext;
import org.apache.shardingsphere.elasticjob.kernel.internal.failover.FailoverService;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.ExecutionContextService;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.ExecutionService;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.ShardingService;
import org.apache.shardingsphere.elasticjob.kernel.tracing.config.TracingConfiguration;
import org.apache.shardingsphere.elasticjob.kernel.tracing.event.JobTracingEventBus;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.spi.executor.item.param.JobRuntimeService;
import org.apache.shardingsphere.elasticjob.spi.listener.ElasticJobListener;
import org.apache.shardingsphere.elasticjob.spi.listener.param.ShardingContexts;
import org.apache.shardingsphere.elasticjob.spi.tracing.event.JobEvent;
import org.apache.shardingsphere.elasticjob.spi.tracing.event.JobExecutionEvent;
import org.apache.shardingsphere.elasticjob.spi.tracing.event.JobStatusTraceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractJobFacade
implements JobFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractJobFacade.class);
    private final ConfigurationService configService;
    private final ShardingService shardingService;
    private final ExecutionContextService executionContextService;
    private final ExecutionService executionService;
    private final FailoverService failoverService;
    private final Collection<ElasticJobListener> elasticJobListeners;
    private final JobTracingEventBus jobTracingEventBus;

    AbstractJobFacade(CoordinatorRegistryCenter regCenter, String jobName, Collection<ElasticJobListener> elasticJobListeners, TracingConfiguration<?> tracingConfig) {
        this.configService = new ConfigurationService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.executionContextService = new ExecutionContextService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.failoverService = new FailoverService(regCenter, jobName);
        this.elasticJobListeners = elasticJobListeners.stream().sorted(Comparator.comparingInt(ElasticJobListener::order)).collect(Collectors.toList());
        this.jobTracingEventBus = null == tracingConfig ? new JobTracingEventBus() : new JobTracingEventBus(tracingConfig);
    }

    @Override
    public JobConfiguration loadJobConfiguration(boolean fromCache) {
        return this.configService.load(fromCache);
    }

    @Override
    public void checkJobExecutionEnvironment() throws JobExecutionEnvironmentException {
        this.configService.checkMaxTimeDiffSecondsTolerable();
    }

    @Override
    public void failoverIfNecessary() {
        if (this.configService.load(true).isFailover()) {
            this.failoverService.failoverIfNecessary();
        }
    }

    @Override
    public void registerJobBegin(ShardingContexts shardingContexts) {
        this.executionService.registerJobBegin(shardingContexts);
    }

    @Override
    public void registerJobCompleted(ShardingContexts shardingContexts) {
        this.executionService.registerJobCompleted(shardingContexts);
        if (this.configService.load(true).isFailover()) {
            this.failoverService.updateFailoverComplete(shardingContexts.getShardingItemParameters().keySet());
        }
    }

    @Override
    public abstract ShardingContexts getShardingContexts();

    @Override
    public boolean misfireIfRunning(Collection<Integer> shardingItems) {
        return this.executionService.misfireIfHasRunningItems(shardingItems);
    }

    @Override
    public void clearMisfire(Collection<Integer> shardingItems) {
        this.executionService.clearMisfire(shardingItems);
    }

    @Override
    public boolean isExecuteMisfired(Collection<Integer> shardingItems) {
        return this.configService.load(true).isMisfire() && !this.isNeedSharding() && !this.executionService.getMisfiredJobItems(shardingItems).isEmpty();
    }

    @Override
    public boolean isNeedSharding() {
        return this.shardingService.isNeedSharding();
    }

    @Override
    public void beforeJobExecuted(ShardingContexts shardingContexts) {
        for (ElasticJobListener each : this.elasticJobListeners) {
            each.beforeJobExecuted(shardingContexts);
        }
    }

    @Override
    public void afterJobExecuted(ShardingContexts shardingContexts) {
        for (ElasticJobListener each : this.elasticJobListeners) {
            each.afterJobExecuted(shardingContexts);
        }
    }

    @Override
    public void postJobExecutionEvent(JobExecutionEvent jobExecutionEvent) {
        this.jobTracingEventBus.post((JobEvent)jobExecutionEvent);
    }

    @Override
    public void postJobStatusTraceEvent(String taskId, JobStatusTraceEvent.State state, String message) {
        TaskContext taskContext = TaskContext.from(taskId);
        this.jobTracingEventBus.post((JobEvent)new JobStatusTraceEvent(taskContext.getMetaInfo().getJobName(), taskContext.getId(), taskContext.getSlaveId(), taskContext.getType(), taskContext.getMetaInfo().getShardingItems().toString(), state, message));
        if (!Strings.isNullOrEmpty((String)message)) {
            log.trace(message);
        }
    }

    @Override
    public JobRuntimeService getJobRuntimeService() {
        return new JobJobRuntimeServiceImpl(this);
    }
}

