/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

plugins {
  id("org.kordamp.gradle.jandex")
  id("polaris-server")
}

dependencies {

  // The dependencies below are included merely to allow IDEs to provide
  // support for Quarkus in this module.
  compileOnly(platform(libs.quarkus.bom))
  compileOnly("io.quarkus:quarkus-logging-json")
  compileOnly("io.quarkus:quarkus-rest-jackson")
  compileOnly("io.quarkus:quarkus-reactive-routes")
  compileOnly("io.quarkus:quarkus-hibernate-validator")
  compileOnly("io.quarkus:quarkus-smallrye-health")
  compileOnly("io.quarkus:quarkus-micrometer")
  compileOnly("io.quarkus:quarkus-micrometer-registry-prometheus")
  compileOnly("io.quarkus:quarkus-oidc")
  compileOnly("io.quarkus:quarkus-opentelemetry")
  compileOnly("io.quarkus:quarkus-smallrye-context-propagation")
}
