/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.sampling.PreambleUtil;
import org.apache.datasketches.sampling.SampleSubsetSummary;
import org.apache.datasketches.sampling.SamplingUtil;
import org.apache.datasketches.sampling.VarOptItemsSamples;
import org.apache.datasketches.sampling.VarOptItemsSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VarOptItemsSketchTest {
    static final double EPS = 1.0E-10;

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidK() {
        VarOptItemsSketch.newInstance((int)0);
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        VarOptItemsSketch<Long> sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(16, 16);
        byte[] bytes = sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        seg.set(ValueLayout.JAVA_BYTE, 1L, (byte)0);
        VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadFamily() {
        VarOptItemsSketch<Long> sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(32, 16);
        byte[] bytes = sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        seg.set(ValueLayout.JAVA_BYTE, 2L, (byte)0);
        VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Assert.fail();
    }

    @Test
    public void checkBadPreLongs() {
        VarOptItemsSketch<Long> sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(32, 33);
        byte[] bytes = sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        seg.set(ValueLayout.JAVA_BYTE, 0L, (byte)(Family.VAROPT.getMinPreLongs() - 1));
        try {
            VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        seg.set(ValueLayout.JAVA_BYTE, 0L, (byte)2);
        try {
            VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        seg.set(ValueLayout.JAVA_BYTE, 0L, (byte)(Family.VAROPT.getMaxPreLongs() + 1));
        try {
            VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadMemorySegment() {
        byte[] bytes = new byte[4];
        MemorySegment seg = MemorySegment.ofArray(bytes);
        try {
            PreambleUtil.getAndCheckPreLongs((MemorySegment)seg);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        bytes = new byte[8];
        bytes[0] = 2;
        seg = MemorySegment.ofArray(bytes);
        PreambleUtil.getAndCheckPreLongs((MemorySegment)seg);
    }

    @Test
    public void checkMalformedPreamble() {
        int k = 50;
        VarOptItemsSketch<Long> sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(50, 50);
        byte[] sketchBytes = sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        MemorySegment srcSeg = MemorySegment.ofArray(sketchBytes);
        byte[] copyBytes = new byte[sketchBytes.length];
        MemorySegment seg = MemorySegment.ofArray(copyBytes);
        MemorySegment.copy(srcSeg, 0L, seg, 0L, sketchBytes.length);
        Assert.assertEquals((int)PreambleUtil.extractPreLongs((MemorySegment)seg), (int)3);
        try {
            PreambleUtil.insertPreLongs((MemorySegment)seg, (int)Family.VAROPT.getMaxPreLongs());
            VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
            Assert.fail();
        }
        catch (SketchesArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Possible Corruption: " + Family.VAROPT.getMaxPreLongs() + " preLongs but"));
        }
        MemorySegment.copy(srcSeg, 0L, seg, 0L, sketchBytes.length);
        Assert.assertEquals((int)PreambleUtil.extractPreLongs((MemorySegment)seg), (int)3);
        try {
            PreambleUtil.insertHRegionItemCount((MemorySegment)seg, (int)-1);
            VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
            Assert.fail();
        }
        catch (SketchesArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().equals("Possible Corruption: H region count cannot be negative: -1"));
        }
        MemorySegment.copy(srcSeg, 0L, seg, 0L, sketchBytes.length);
        Assert.assertEquals((int)PreambleUtil.extractHRegionItemCount((MemorySegment)seg), (int)50);
        try {
            PreambleUtil.insertRRegionItemCount((MemorySegment)seg, (int)-128);
            VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
            Assert.fail();
        }
        catch (SketchesArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().equals("Possible Corruption: R region count cannot be negative: -128"));
        }
        MemorySegment.copy(srcSeg, 0L, seg, 0L, sketchBytes.length);
        Assert.assertEquals((int)PreambleUtil.extractRRegionItemCount((MemorySegment)seg), (int)0);
        try {
            PreambleUtil.insertK((MemorySegment)seg, (int)0);
            VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
            Assert.fail();
        }
        catch (SketchesArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().equals("Possible Corruption: k must be at least 1: 0"));
        }
        MemorySegment.copy(srcSeg, 0L, seg, 0L, sketchBytes.length);
        Assert.assertEquals((int)PreambleUtil.extractK((MemorySegment)seg), (int)50);
        try {
            PreambleUtil.insertN((MemorySegment)seg, (long)-1024L);
            VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
            Assert.fail();
        }
        catch (SketchesArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().equals("Possible Corruption: n cannot be negative: -1024"));
        }
    }

    @Test
    public void checkEmptySketch() {
        VarOptItemsSketch vis = VarOptItemsSketch.newInstance((int)5);
        Assert.assertEquals((long)vis.getN(), (long)0L);
        Assert.assertEquals((int)vis.getNumSamples(), (int)0);
        Assert.assertNull((Object)vis.getSamplesAsArrays());
        Assert.assertNull((Object)vis.getSamplesAsArrays(Long.class));
        byte[] sketchBytes = vis.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        MemorySegment seg = MemorySegment.ofArray(sketchBytes);
        Assert.assertEquals((int)sketchBytes.length, (int)(Family.VAROPT.getMinPreLongs() << 3));
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        VarOptItemsSketch loadedVis = VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)serDe);
        Assert.assertEquals((int)loadedVis.getNumSamples(), (int)0);
        VarOptItemsSketchTest.println("Empty sketch:");
        VarOptItemsSketchTest.println("  Preamble:");
        VarOptItemsSketch.toString((byte[])sketchBytes);
        VarOptItemsSketchTest.println(VarOptItemsSketch.toString((MemorySegment)seg));
        VarOptItemsSketchTest.println("  Sketch:");
        VarOptItemsSketchTest.println(vis.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkNonEmptyDegenerateSketch() {
        VarOptItemsSketch vis = VarOptItemsSketch.newInstance((int)12, (ResizeFactor)ResizeFactor.X2);
        byte[] sketchBytes = vis.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        byte[] dstByteArr = new byte[24];
        MemorySegment seg = MemorySegment.ofArray(dstByteArr);
        MemorySegment.copy(sketchBytes, 0, seg, ValueLayout.JAVA_BYTE, 0L, sketchBytes.length);
        PreambleUtil.insertFlags((MemorySegment)seg, (int)0);
        PreambleUtil.insertHRegionItemCount((MemorySegment)seg, (int)0);
        PreambleUtil.insertRRegionItemCount((MemorySegment)seg, (int)0);
        VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidWeight() {
        VarOptItemsSketch vis = VarOptItemsSketch.newInstance((int)5);
        try {
            vis.update(null, 1.0);
        }
        catch (SketchesArgumentException e) {
            Assert.fail();
        }
        vis.update((Object)"invalidWeight", -1.0);
    }

    @Test
    public void checkCorruptSerializedWeight() {
        VarOptItemsSketch vis = VarOptItemsSketch.newInstance((int)24);
        for (int i = 1; i < 10; ++i) {
            vis.update((Object)Integer.toString(i), (double)i);
        }
        byte[] sketchBytes = vis.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe(), String.class);
        MemorySegment seg = MemorySegment.ofArray(sketchBytes);
        int numPreLongs = PreambleUtil.extractPreLongs((MemorySegment)seg);
        int weightOffset = numPreLongs << 3;
        seg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)weightOffset, -1.25);
        try {
            VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
            Assert.fail();
        }
        catch (SketchesArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().equals("Possible Corruption: Non-positive weight in heapify(): -1.25"));
        }
    }

    @Test
    public void checkCumulativeWeight() {
        int k = 256;
        int n = 2560;
        VarOptItemsSketch sketch = VarOptItemsSketch.newInstance((int)256);
        double inputSum = 0.0;
        for (long i = 0L; i < 2560L; ++i) {
            double w = Math.exp(5.0 * SamplingUtil.rand().nextGaussian());
            inputSum += w;
            sketch.update((Object)i, w);
        }
        VarOptItemsSamples samples = sketch.getSketchSamples();
        double outputSum = 0.0;
        for (VarOptItemsSamples.WeightedSample ws : samples) {
            outputSum += ws.getWeight();
        }
        double wtRatio = outputSum / inputSum;
        Assert.assertTrue((Math.abs(wtRatio - 1.0) < 1.0E-10 ? 1 : 0) != 0);
    }

    @Test
    public void checkUnderFullSketchSerialization() {
        VarOptItemsSketch sketch = VarOptItemsSketch.newInstance((int)2048);
        for (long i = 0L; i < 10L; ++i) {
            sketch.update((Object)i, 1.0);
        }
        Assert.assertEquals((int)sketch.getNumSamples(), (int)10);
        byte[] bytes = sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        Assert.assertEquals((int)PreambleUtil.extractPreLongs((MemorySegment)seg), (int)3);
        VarOptItemsSketch rebuilt = VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        VarOptItemsSketchTest.checkIfEqual(rebuilt, sketch);
    }

    @Test
    public void checkEndOfWarmupSketchSerialization() {
        int k = 2048;
        VarOptItemsSketch<Long> sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(2048, 2048);
        byte[] bytes = sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        Assert.assertEquals((int)PreambleUtil.extractPreLongs((MemorySegment)seg), (int)3);
        VarOptItemsSketch rebuilt = VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        VarOptItemsSketchTest.checkIfEqual(rebuilt, sketch);
    }

    @Test
    public void checkFullSketchSerialization() {
        VarOptItemsSketch sketch = VarOptItemsSketch.newInstance((int)32);
        for (long i = 0L; i < 32L; ++i) {
            sketch.update((Object)i, 1.0);
        }
        sketch.update((Object)100L, 100.0);
        sketch.update((Object)101L, 101.0);
        Assert.assertEquals((int)sketch.getNumSamples(), (int)32);
        VarOptItemsSamples samples = sketch.getSketchSamples();
        Long[] data = (Long[])samples.items();
        double[] weights = samples.weights();
        Assert.assertEquals((double)weights[0], (double)100.0);
        Assert.assertEquals((double)weights[1], (double)101.0);
        Assert.assertEquals((long)data[0], (long)100L);
        Assert.assertEquals((long)data[1], (long)101L);
        byte[] bytes = sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        Assert.assertEquals((int)PreambleUtil.extractPreLongs((MemorySegment)seg), (int)Family.VAROPT.getMaxPreLongs());
        VarOptItemsSketch rebuilt = VarOptItemsSketch.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        VarOptItemsSketchTest.checkIfEqual(rebuilt, sketch);
    }

    @Test
    public void checkPseudoLightUpdate() {
        int k = 1024;
        VarOptItemsSketch<Long> sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(1024, 1025);
        sketch.update((Object)0L, 1.0);
        VarOptItemsSamples samples = sketch.getSketchSamples();
        double wtDiff = samples.weights(0) - 1.001953125;
        Assert.assertTrue((Math.abs(wtDiff) < 1.0E-10 ? 1 : 0) != 0);
    }

    @Test
    public void checkPseudoHeavyUpdates() {
        long i;
        int k = 1024;
        double wtScale = 10240.0;
        VarOptItemsSketch sketch = VarOptItemsSketch.newInstance((int)1024);
        for (i = 0L; i <= 1024L; ++i) {
            sketch.update((Object)i, 1.0);
        }
        for (i = 1L; i <= 1024L; ++i) {
            sketch.update((Object)(-i), 1024.0 + (double)i * 10240.0);
        }
        VarOptItemsSamples samples = sketch.getSketchSamples();
        double[] weights = samples.weights();
        double wtDiff = weights[1023] - 12289.0;
        Assert.assertTrue((Math.abs(wtDiff) < 1.0E-10 ? 1 : 0) != 0);
        wtDiff = weights[0] - 21504.0;
        Assert.assertTrue((Math.abs(wtDiff) < 1.0E-10 ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void checkDecreaseKWithUnderfullSketch() {
        VarOptItemsSketch sketch = VarOptItemsSketch.newInstanceAsGadget((int)5);
        Assert.assertEquals((int)sketch.getK(), (int)5);
        sketch.decreaseKBy1();
        Assert.assertEquals((int)sketch.getK(), (int)4);
        sketch.update((Object)1, 1.0);
        sketch.update((Object)2, 2.0);
        sketch.update((Object)3, 3.0);
        Assert.assertEquals((double)sketch.getTotalWtR(), (double)0.0);
        sketch.decreaseKBy1();
        Assert.assertEquals((double)sketch.getTotalWtR(), (double)0.0);
        sketch.decreaseKBy1();
        Assert.assertEquals((int)sketch.getHRegionCount(), (int)1);
        Assert.assertEquals((int)sketch.getRRegionCount(), (int)1);
        Assert.assertEquals((double)sketch.getTotalWtR(), (double)3.0);
        sketch.decreaseKBy1();
        sketch.decreaseKBy1();
    }

    @Test
    public void checkDecreaseKWithFullSketch() {
        int[] itemList = new int[]{10, 1, 9, 2, 8, 3, 7, 4, 6, 5};
        int startK = 7;
        int tgtK = 5;
        VarOptItemsSketch sketch = VarOptItemsSketch.newInstanceAsGadget((int)7);
        VarOptItemsSketch tgtSketch = VarOptItemsSketch.newInstanceAsGadget((int)5);
        double totalWeight = 0.0;
        for (int val : itemList) {
            sketch.update((Object)val, (double)val);
            tgtSketch.update((Object)val, (double)val);
            totalWeight += (double)val;
        }
        Assert.assertEquals((int)sketch.getHRegionCount(), (int)4);
        Assert.assertEquals((int)sketch.getRRegionCount(), (int)3);
        Assert.assertEquals((int)tgtSketch.getHRegionCount(), (int)0);
        Assert.assertEquals((int)tgtSketch.getRRegionCount(), (int)5);
        while (sketch.getK() > 5) {
            sketch.decreaseKBy1();
        }
        Assert.assertEquals((int)sketch.getK(), (int)tgtSketch.getK());
        Assert.assertEquals((int)sketch.getHRegionCount(), (int)0);
        Assert.assertTrue((Math.abs(sketch.getTau() - tgtSketch.getTau()) < 1.0E-10 ? 1 : 0) != 0);
        sketch.decreaseKBy1();
        Assert.assertEquals((int)sketch.getK(), (int)4);
        Assert.assertEquals((int)sketch.getK(), (int)sketch.getRRegionCount());
        Assert.assertEquals((double)sketch.getTotalWtR(), (double)totalWeight);
    }

    @Test
    public void checkReset() {
        int k = 25;
        VarOptItemsSketch sketch = VarOptItemsSketch.newInstanceAsGadget((int)25);
        sketch.update((Object)"a", 1.0);
        sketch.update((Object)"b", 2.0);
        sketch.update((Object)"c", 3.0);
        sketch.update((Object)"d", 4.0);
        Assert.assertEquals((long)sketch.getN(), (long)4L);
        Assert.assertEquals((int)sketch.getHRegionCount(), (int)4);
        Assert.assertEquals((int)sketch.getRRegionCount(), (int)0);
        Assert.assertEquals((boolean)sketch.getMark(0), (boolean)false);
        sketch.reset();
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getHRegionCount(), (int)0);
        Assert.assertEquals((int)sketch.getRRegionCount(), (int)0);
        try {
            sketch.getMark(0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sketch.stripMarks();
        for (int i = 0; i < 50; ++i) {
            sketch.update((Object)"a", 100.0 + (double)i);
        }
        Assert.assertEquals((long)sketch.getN(), (long)50L);
        Assert.assertEquals((int)sketch.getHRegionCount(), (int)0);
        Assert.assertEquals((int)sketch.getRRegionCount(), (int)25);
        sketch.reset();
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getHRegionCount(), (int)0);
        Assert.assertEquals((int)sketch.getRRegionCount(), (int)0);
    }

    @Test
    public void checkEstimateSubsetSum() {
        long i;
        int k = 10;
        VarOptItemsSketch sketch = VarOptItemsSketch.newInstance((int)10);
        SampleSubsetSummary ss = sketch.estimateSubsetSum(item -> true);
        Assert.assertEquals((double)ss.getEstimate(), (double)0.0);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)0.0);
        double totalWeight = 0.0;
        for (i = 1L; i <= 9L; ++i) {
            sketch.update((Object)i, 1.0 * (double)i);
            totalWeight += 1.0 * (double)i;
        }
        ss = sketch.estimateSubsetSum(item -> true);
        Assert.assertEquals((double)ss.getEstimate(), (double)totalWeight);
        Assert.assertEquals((double)ss.getLowerBound(), (double)totalWeight);
        Assert.assertEquals((double)ss.getUpperBound(), (double)totalWeight);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)totalWeight);
        for (i = 10L; i <= 11L; ++i) {
            sketch.update((Object)i, 1.0 * (double)i);
            totalWeight += 1.0 * (double)i;
        }
        ss = sketch.estimateSubsetSum(item -> true);
        Assert.assertEquals((double)ss.getEstimate(), (double)totalWeight);
        Assert.assertEquals((double)ss.getUpperBound(), (double)totalWeight);
        Assert.assertTrue((ss.getLowerBound() < totalWeight ? 1 : 0) != 0);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)totalWeight);
        ss = sketch.estimateSubsetSum(item -> false);
        Assert.assertEquals((double)ss.getEstimate(), (double)0.0);
        Assert.assertEquals((double)ss.getLowerBound(), (double)0.0);
        Assert.assertTrue((ss.getUpperBound() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)totalWeight);
        for (i = 1L; i <= 11L; ++i) {
            sketch.update((Object)(-i), 1.0 * (double)i);
            totalWeight += 1.0 * (double)i;
        }
        ss = sketch.estimateSubsetSum(item -> item < 0L);
        Assert.assertTrue((ss.getEstimate() >= ss.getLowerBound() ? 1 : 0) != 0);
        Assert.assertTrue((ss.getEstimate() <= ss.getUpperBound() ? 1 : 0) != 0);
        Assert.assertTrue((ss.getLowerBound() < totalWeight / 1.4 ? 1 : 0) != 0);
        Assert.assertTrue((ss.getUpperBound() > totalWeight / 2.6 ? 1 : 0) != 0);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)totalWeight);
        VarOptItemsSketch boolSketch = VarOptItemsSketch.newInstance((int)10);
        totalWeight = 0.0;
        for (int i2 = 1; i2 <= 9; ++i2) {
            boolSketch.update((Object)(i2 % 2 == 0 ? 1 : 0), 1.0 * (double)i2);
            totalWeight += (double)i2;
        }
        ss = boolSketch.estimateSubsetSum(item -> item == false);
        Assert.assertTrue((ss.getEstimate() == ss.getLowerBound() ? 1 : 0) != 0);
        Assert.assertTrue((ss.getEstimate() == ss.getUpperBound() ? 1 : 0) != 0);
        Assert.assertTrue((ss.getEstimate() < totalWeight ? 1 : 0) != 0);
    }

    static VarOptItemsSketch<Long> getUnweightedLongsVIS(int k, int n) {
        VarOptItemsSketch sketch = VarOptItemsSketch.newInstance((int)k);
        for (long i = 0L; i < (long)n; ++i) {
            sketch.update((Object)i, 1.0);
        }
        return sketch;
    }

    private static <T> void checkIfEqual(VarOptItemsSketch<T> s1, VarOptItemsSketch<T> s2) {
        Assert.assertEquals((int)s1.getK(), (int)s2.getK(), (String)"Sketches have different values of k");
        Assert.assertEquals((int)s1.getNumSamples(), (int)s2.getNumSamples(), (String)"Sketches have different sample counts");
        int len = s1.getNumSamples();
        VarOptItemsSamples r1 = s1.getSketchSamples();
        VarOptItemsSamples r2 = s2.getSketchSamples();
        Assert.assertEquals((int)len, (int)r1.getNumSamples());
        Assert.assertEquals((int)r1.getNumSamples(), (int)r2.getNumSamples());
        for (int i = 0; i < len; ++i) {
            Assert.assertEquals((Object)r1.items(i), (Object)r2.items(i), (String)("Data values differ at sample " + i));
            Assert.assertEquals((double)r1.weights(i), (double)r2.weights(i), (String)("Weights differ at sample " + i));
        }
    }

    private static void println(String msg) {
    }
}

