/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.datasketches.common.TestUtil;
import org.apache.datasketches.quantilescommon.QuantilesFloatsSketchIterator;
import org.apache.datasketches.req.ReqSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReqSketchCrossLanguageTest {
    @Test(groups={"generate_java_files"})
    public void generateBinariesForCompatibilityTesting() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            ReqSketch sk = ReqSketch.builder().build();
            for (int i = 1; i <= n; ++i) {
                sk.update((float)i);
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("req_float_n" + n + "_java.sk"), new OpenOption[0]).write(sk.toByteArray());
        }
    }

    @Test(groups={"check_cpp_files"})
    public void deserializeFromCpp() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("req_float_n" + n + "_cpp.sk"));
            ReqSketch sk = ReqSketch.heapify((MemorySegment)MemorySegment.ofArray(bytes));
            Assert.assertTrue((boolean)(n == 0 ? sk.isEmpty() : !sk.isEmpty()));
            Assert.assertTrue((boolean)(n > 10 ? sk.isEstimationMode() : !sk.isEstimationMode()));
            Assert.assertEquals((long)sk.getN(), (long)n);
            if (n <= 0) continue;
            Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
            Assert.assertEquals((float)sk.getMaxItem(), (float)n);
            QuantilesFloatsSketchIterator it = sk.iterator();
            long weight = 0L;
            while (it.next()) {
                Assert.assertTrue((it.getQuantile() >= sk.getMinItem() ? 1 : 0) != 0);
                Assert.assertTrue((it.getQuantile() <= sk.getMaxItem() ? 1 : 0) != 0);
                weight += it.getWeight();
            }
            Assert.assertEquals((long)weight, (long)n);
        }
    }
}

