/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Random;
import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public class JDKRandom
extends IntProvider {
    private Random delegate;

    public JDKRandom(Long seed) {
        this.delegate = new Random(seed);
    }

    @Override
    public int next() {
        return this.delegate.nextInt();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] getStateInternal() {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(this.delegate);
                byte[] state = bos.toByteArray();
                int stateSize = state.length;
                byte[] sizeAndState = this.composeStateInternal(NumberFactory.makeByteArray(stateSize), state);
                byArray = this.composeStateInternal(sizeAndState, super.getStateInternal());
            }
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] s2 = this.splitStateInternal(s, 4);
        int stateSize = NumberFactory.makeInt(s2[0]);
        byte[][] c = this.splitStateInternal(s2[1], stateSize);
        try (ByteArrayInputStream bis = new ByteArrayInputStream(c[0]);
             ValidatingObjectInputStream ois = new ValidatingObjectInputStream(bis);){
            this.delegate = (Random)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        super.setStateInternal(c[1]);
    }

    private static final class ValidatingObjectInputStream
    extends ObjectInputStream {
        ValidatingObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
            if (!Random.class.getName().equals(osc.getName())) {
                throw new IllegalStateException("Stream does not contain java.util.Random: " + osc.getName());
            }
            return super.resolveClass(osc);
        }
    }
}

